program lp_drinking_unified_prog, rclass
	set more off
	capture drop __0000*
	
	/*	
		`1' is aggregation level
		`2' is earliest year
		`3' is latest year
		`4' is the first hour
		`5' is the last hour
		`6' is equal mixing
		`7' is the drinking definition
		`8' is the threshold for tossing state-year observations because of missing data (LP state they do this, but the threshold is unclear)
		`9' is the BAC threshold below which positive values are set to missing
		`10' is the multiple imputation set to use. if missing or zero, do not use multiple imputation.
	*/
	
	/*
	* for debugging
	loc 1 "agg_agg"
	loc 2 1983 
	loc 3 1993 
	loc 4 24 
	loc 5 0 
	loc 6 "i.hour#i.state#i.year#i.weekend"
	loc 7 5
	loc 8 .13 
	loc 9 0 
	loc 10 0
	*/
	
	local agg_level = "`1'"
	

	if "`10'" == "" local mi_set = 0
	else local mi_set = `10'

	capture mkdir "unified LP output"
	capture log close
	log using "unified LP output\lp_`1'_`2'_`3'_`4'_`5'_`6'_`7'_`8'_`9'_`mi_set'.smcl", replace

	display "Method:  `1'"
	display "Years: `2' - `3'"
	display "Hours:  `4'"
	display "Equal Mixing Assumed:  `6'"
	display "Drinking definition:  `7'"
	display "Missing threshold:  `8'"

	log off

	*quietly log off

	*use "..\descriptive analysis\ddwc_fars_extract.dta", clear /* FILE WE USED FOR THE INITIAL SUBMISSION */
	
	/* BUILD DATASET OF DRIVERS WITH VEHICLE AND ACCIDENT CHARACTERISTICS MERGED IN */
	use ddwc_person, clear
	keep if seat_pos == 11 /* KEEP ONLY THE DRIVERS */ 
	duplicates tag year st_case veh_no, gen(dup) /* SEVERAL VEHICLES LIST MULTIPLE DRIVERS...DROP THOSE CASES */
	drop if dup > 0
	drop dup
	count
	display "Count of all drivers: " `r(N)'
	
	merge 1:1 year st_case veh_no using ddwc_vehicle, keep(match using) nogen /* NEED TO IDENTIFY ACCIDENTS IN WHICH NOT ALL VEHICLES HAVE A DRIVER */
	merge m:1 year st_case using ddwc_accident, keep(match using) nogen /* NEED TO IDENTIFY ACCIDENTS IN WHICH NOT ALL VEHICLES HAVE A DRIVER */
	gen per_no_miss_flag = per_no == .
	bysort year st_case: egen max_per_no_miss_flag = max(per_no_miss_flag)
	drop if max_per_no_miss_flag == 1 /* DROP CASES WHERE DRIVERS ARE MISSING */
	
	count
	display "Count after merging vehicles and accidents: " `r(N)'
	
	if `mi_set' ~= 0 {
		replace alcohol_test_result=p`mi_set'
	}
	
	** Set interval of study
	/* page 1213, paragraph 2: "we restrict the analysis of the paper to the years 1983–93" */
		keep if year>=`2' & year <=`3' 
			count
			local restriction_1 = r(N)
			egen crash_tag=tag(st_case year)
			count if crash_tag==1
			local restriction_1a = r(N)
			drop crash_tag

	quietly log on
	display "Drivers `2' - `3': " `restriction_1'
	display "Crashes `2' - `3': " `restriction_1a'
	quietly log off

	** Keep only night-time crashes 

			* Count missing hours
			count if hour==.
			local restriction_2_miss = r(N)

	/* page 1213, paragraph 2: "we limit our sample to those hours (8:00 p.m.–5:00 a.m.) in which drinking and driving is most common" */
		
		if `4'==24 {
			keep if hour != . & (hour <= 4 | hour >= 20)
		}	
		else {
			keep if hour !=. & hour==`5'
		}
			count
			local restriction_2 = r(N)
			egen crash_tag=tag(st_case year)
			count if crash_tag==1
			local restriction_2a = r(N)
			drop crash_tag
			
	quietly log on
	display "Missing hours `5': " `restriction_2_miss'
	display "Drivers within hours `5': " `restriction_2'
	display "Crashes within hours `5': " `restriction_2a'
	quietly log off

	** Keep only crashes with one or two vehicles
		** NOTE: Don't want to deal with type of vehicle right now
		bysort st_case year: egen num_vehicles=count(veh_no)

			count if num_vehicles==1
			local restriction_3 = r(N)
			count if num_vehicles==2
			local restriction_3a = r(N)/2

	quietly log on
	display "One vehicle crashes (`5': " `restriction_3'
	display "Two vehicle crashes (`5': " `restriction_3a'
	quietly log off
		
	/* page 1213, paragraph 2: "Our sample includes over 100,000 one-car crashes and over 40,000 two-car crashes." */
		preserve
		collapse num_vehicles, by(st_case year)
		
		quietly log on
		** Distribution of crashes by number of vehicles **
		tab num_vehicles
		quietly log off
		restore

	* page 1213, paragraph 2: "Crashes involving three or more drivers, which represent less than 6 percent of fatal crashes, are dropped from the sample."
		keep if num_vehicles==1|num_vehicles==2
		count 
		
		gen dr_num=.
		egen dr_tag=tag(st_case year) 
		replace dr_num=1 if dr_tag==1
		replace dr_num=2 if dr_tag==0
		
		drop dr_tag 

	gen bac_zero_pos_miss = alcohol_test_result > 0 if alcohol_test_result != .
	quietly log on
	/* Cross-tab for Table 2: Distribution of police officer judgement of alcohol involvement and BAC test results  */
	tab bac_zero_pos_miss drinking, mi cell
	quietly log off

	* page 1213, paragraph 2: "All crashes from a handful of state-year pairs with obvious data problems are also eliminated."
	* WTF?!?


	** Need to handle observations with missing and/or unknown data
		** NOTE: Don't want to deal with what a minor blemish is right now
	/* page 1213, paragraph 3: "we exclude from the sample any crash in which one or more of the drivers are missing information about the time or location 
		of the accident, police-reported drinking status, age, sex, or past driving record. Combined, these missing data lead to the exclusion of roughly 
		8 percent of all crashes." */
		
	*quietly {

	gen miss_flag=0
	gen excluded_drink_status_flag = 0
	egen crash_tag=tag(st_case year)

		/*AGE				*/ 	
								local miss_age_if = " (year<=2008 & (dr_age==99|dr_age==.|dr_age<13)) | (year>=2009 & (dr_age==998|dr_age==999|dr_age==.|dr_age<13)) "
								egen crash_miss_age = max(`miss_age_if'), by(st_case year)
								replace miss_flag = 1 if `miss_age_if'
															
		/*SEX				*/ 	local miss_sex_if = " (year>=1975 & year<=2009) & dr_male==. "
								egen crash_miss_sex = max(`miss_sex_if'), by(st_case year)
								replace miss_flag = 1 if `miss_sex_if'

		/*Drinking status	*/ 	
								if `7'==1 { /* police officer report [0 if nondrinking, 1 if drinking, 8 if not reported, 9 if unknown] (definition 1 in paper; what LP say they use) */
									gen drink_status=drinking if !inlist(drinking,8,9)
									local miss_drink_status_if = " (drink_status==.|drink_status==8|drink_status==9) " /* need to keep 8's and 9's here to properly impose state-year BAC restriction */
									local excluded_drink_status_if = " (0==1) "
								}
								else if `7'==2 { /* drinking if any evidence, not drinking otherwise (definition 2 in paper; what LP use) */
									gen drink_status=dr_drink
									local miss_drink_status_if = " (drink_status==.|drink_status==8|drink_status==9) "
									local excluded_drink_status_if = " (0==1) "
								}
								else if `7'==3 { /* officer report primary, missing values adjusted by BAC test (definition 3 in paper) */
									gen drink_status=drinking if !inlist(drinking,8,9)
									replace drink_status=0 if drink_status == . & alcohol_test_result==0
									replace drink_status=1 if drink_status == . & alcohol_test_result>`9' & alcohol_test_result!=.
									local miss_drink_status_if = " (drink_status==.|drink_status==8|drink_status==9 ) " 
									local excluded_drink_status_if = " (0==1) "
								}
								else if `7'==4 { /* BAC primary (definition 4 in paper) */
									gen drink_status=drinking if !inlist(drinking,8,9)
									replace drink_status=0 if alcohol_test_result==0  
									replace drink_status=1 if alcohol_test_result>`9' & alcohol_test_result!=. 
									replace drink_status=. if alcohol_test_result>0 & alcohol_test_result<=`9'
									local miss_drink_status_if = " (drink_status==.|drink_status==8|drink_status==9 ) "
									local excluded_drink_status_if = " (alcohol_test_result>0 & alcohol_test_result<=`9') "
								}
								else if `7'==5 { /* Legal impairment based on tested BAC (supplemental analysis in LP) */
									gen drink_status=.
									replace drink_status=0 if alcohol_test_result==0 | dr_drink == 0
									replace drink_status=1 if alcohol_test_result>=`9' & alcohol_test_result~=.
									local miss_drink_status_if = " (dr_drink!=0 & alcohol_test_result==. ) "
									local excluded_drink_status_if = " (alcohol_test_result>0 & alcohol_test_result<=`9') "
								}
								else if `7'==6 { /* new definition that uses only BAC test (should use for multiple imputation to drop legal drinkers) */
									gen drink_status=.
									replace drink_status=0 if alcohol_test_result==0
									replace drink_status=1 if (alcohol_test_result!=.) & (alcohol_test_result>`9') 
									local miss_drink_status_if = " (alcohol_test_result==.) "
									local excluded_drink_status_if = " (alcohol_test_result>0 & alcohol_test_result<=`9') "
								}
								
								* this was previously the restriction for every defintion
								*local miss_drink_status_if = " (drink_status==.|drink_status==8|drink_status==9 ) & `7'~=5 " /* need to keep missings here to impose state-year BAC restriction */
								
								*egen crash_miss_drink_status = max(`miss_drink_status_if'), by(st_case year)
								replace miss_flag=1 if `miss_drink_status_if'
								replace excluded_drink_status_flag=1 if `excluded_drink_status_if'
								
		/*Hour				*/ 	local miss_hour_if = " hour == . "
								egen crash_miss_hour = max(`miss_hour_if'), by(st_case year)
								replace miss_flag=1 if `miss_hour_if'
		
		/*Day of Week		*/ 	local miss_day_if = " day_week == . "
								egen crash_miss_day = max(`miss_day_if'), by(st_case year)
								replace miss_flag=1 if `miss_day_if'

		/*State				*/ 	local miss_state_if = " state == . "
								egen crash_miss_state = max(`miss_state_if'), by(st_case year)
								replace miss_flag=1 if `miss_state_if'
		
		/*Driving History  	
			A bad driving record is defined as two or more minor blemishes (a moving
			violation or previous accident) or one or more major blemishes (previous DUI
			conviction, license suspension, or license revocation) in the last five years */
		
		/* Minor blemishes	*/	local miss_minor_blemishes_if = " prev_acc==.|prev_acc==98|prev_acc==99|prev_acc==998 | prev_spd==.|prev_spd==98|prev_spd==99|prev_spd==998 | prev_oth==.|prev_oth==98|prev_oth==99|prev_oth==998 "
								egen crash_miss_minor_blemishes = max(`miss_minor_blemishes_if'), by(st_case year)
								replace miss_flag=1 if `miss_minor_blemishes_if'
															
		/* Major blemishes	*/	local miss_major_blemishes_if = " prev_sus==.|prev_sus==98|prev_sus==99|prev_sus==998 | prev_dwi==.|prev_dwi==98|prev_dwi==99|prev_dwi==998 "
								egen crash_miss_major_blemishes = max(`miss_major_blemishes_if'), by(st_case year)
								gen crash_miss_any_blemishes = crash_miss_minor_blemishes | crash_miss_major_blemishes if (crash_miss_minor_blemishes != . & crash_miss_major_blemishes != .)
								replace miss_flag=1 if `miss_major_blemishes_if'
	
	** Generate flag for missing BAC test result when using definition 5

	/* page 1214, paragraph 2: "Thus, for the purpose of analysis, we compare two groups of drivers: (1) those with measured BAC greater
		than 0.10 percent (the legal limit in most states for most of the sample period) and (2) those who test free of alcohol or who are not tested
		but whom police describe as not having been drinking. We eliminate those who test positive for alcohol but are below the 0.10 threshold." */
	if `7'==5 & `mi_set' == 0 {
		gen at_flag_drink=0 if dr_drink==1 & alcohol_test_result==. 
		replace at_flag_drink=1 if dr_drink==1 & alcohol_test_result~=.
		
		egen at_flag=mean(at_flag_drink), by(state year)
		gen at_flag_low = at_flag<0.9499999 /* precision issue, in order to include Montana in 1992, which is exactly 95% */
		*egen crash_tag=tag(st_case year)
		
		quietly log on
		/* FOR BOTTOM HALF OF TABLE 1 */
		/* page 1214, paragraph 2: "we exclude all crashes occurring in states that do not test at least 95 percent of those judged to have been drinking 
		by the police in our sample in that year (regardless of whether the motorist in question was tested). This requirement excludes more than 80 percent 
		of the fatal crashes in the sample." */
		sum at_flag_low if crash_tag == 1
		quietly log off
		
		drop if at_flag_low == 1 
		*drop crash_tag
		/*
		gen miss_drink_status = drink_status == .
		egen md_flag=max(miss_drink_status), by(st_case year)
		drop if md_flag != 0
		*/
	}
	
	/* MARK EXCLUDED CRASHES WHEN COMPARING NON-DRINKERS TO IMPAIRED */
	bysort st_case year: egen acc_excluded_flag=max(excluded_drink_status_flag)
	
	quietly log on
	/* CALCULATE THE PERCENTS OF CRASHES WITH MISSING INFORMATION FOR EACH OF THE BASIC EXCLUSION CRITERIA */
	sum crash_miss_* if crash_tag == 1, sep(0)
	quietly log off
	*drop crash_tag					

	** Calculate the proportion of crashes in a state-year with at least one piece of missing information
	
	bysort st_case year: egen acc_flag=max(miss_flag)
		
	bysort state year: egen st_flag_calc=mean(acc_flag) if crash_tag == 1 /* Need crash tag here to get correct denominator */
	bysort state year: egen st_flag=min(st_flag_calc)
	

	/* for detailed look at missing data by state and year */
	preserve
		collapse st_flag, by(state year)
		save state_year_missing_data, replace 
	restore
		
	quietly log on
		** Drop state-year observations with proportion missing above threshold
		disp "Count of accidents by state and year that are above state-year missing proportion sample restriction: "
		tab year state if st_flag>=`8' & crash_tag == 1
		drop if st_flag>=`8'
		count if crash_tag == 1
		disp "Count of accidents after state-year missing proportion sample restriction: `r(N)'"
	
		/* For Table 3: Potential definitions of drinking driver (BEFORE DROPPING MISSING VALUES, CALCULATE CONDITIONAL AND UNCONDITIONAL PERCENTS OF DRINKING DRIVERS) */
		tab drink_status
		tab drink_status if inlist(drink_status,0,1)
	quietly log off

		** Calculate the proportion of accidents that will be dropped in the remaining state-year observations because of missing info
		egen tag=tag(st_case year)
		
		sum acc_flag if tag==1
		local restriction_7 =r(mean)
		drop if acc_flag!=0
		count if crash_tag == 1
		disp "Count of accidents after state-year missing data sample restriction: `r(N)'"
		
		drop tag acc_flag miss_flag

	quietly log on
	display "% of observations dropped because of missing: " `restriction_7'
	quietly log off
		
	*exclude drivers whose drinking status has been excluded
	drop if excluded_drink_status_flag == 1

	quietly log on
	/* FOR TABLE 4 (TOP HALF OF TABLE 4 IS WHEN SAMPLE IS UNRESTRICTED) */

		* summary stats by crash
		preserve
		collapse drink_status num_vehicles, by(st_case year)
		tab num_vehicles
		tab drink_status if num_vehicles == 1
		tab drink_status if num_vehicles == 2
		restore
	quietly log off

		* summary stats by drivers (none of these should have missing values)
		gen dr_age_lt25 = dr_age < 25
		gen dr_minor_blemishes = prev_acc + prev_spd + prev_oth
		gen dr_major_blemishes = prev_sus + prev_dwi
		gen dr_bad_record = dr_minor_blemishes >= 2 | dr_major_blemishes >= 1
		gen dr_male_and_drinking = dr_male == 1 & drink_status == 1
		gen dr_age_lt25_and_drinking = dr_age_lt25 == 1 & drink_status == 1
		gen drink_status_and_bad_record = drink_status == 1 & dr_bad_record == 1

	quietly log on
		sum drink_status dr_male dr_age_lt25 dr_bad_record dr_male_and_drinking dr_age_lt25_and_drinking drink_status_and_bad_record, sep(0)
	quietly log off


	** Define weekend as Friday or Saturday nights, as Levitt and Porter do
	gen weekend = (day_week == 6 & hour >= 20) | (day_week == 7) | (day_week == 1 & hour <= 4)

	egen tag=tag(st_case year)

	tab tag
	
	/* DROP ACCIDENT IF IT HAS AN EXCLUDED DRIVER WHEN COMPARING NON-DRINKERS TO IMPAIRED */
	drop if acc_excluded_flag == 1
	
	** Build dataset

	*quietly {
	
	bysort st_case year: egen tot_drinking = sum(drink_status)

	** Determine the drinking status of each driver

	gen drink_1=.
	replace drink_1=drink_status if dr_num==1
	replace drink_1=tot_drinking - drink_status if dr_num==2

	gen drink_2=.
	replace drink_2=drink_status if dr_num==2
	replace drink_2=tot_drinking - drink_status if dr_num==1 & num_vehicles==2

	** Classify accident by drinking status and number of vehicles

	gen a_2_2=0
	replace a_2_2=1 if tot_drinking==2 & num_vehicles==2

	gen a_1_2=0
	replace a_1_2=1 if tot_drinking==1 & num_vehicles==2

	gen a_1_1=0
	replace a_1_1=1 if tot_drinking==0 & num_vehicles==2

	gen a_1=0
	replace a_1=1 if tot_drinking==0 & num_vehicles==1

	gen a_2=0
	replace a_2=1 if tot_drinking==1 & num_vehicles==1

	** Keep only the first vehicle in each crash

	keep if dr_num==1

	** Calculate the number of accidents at the state-year-hour-weekend level
	if "`agg_level'" == "agg_agg" {
		local eq_mix = subinstr(subinstr("`6'","#i."," ",.),"i.","",.)
		* for now, change "cons_one" to "weekend" because agg-agg only yields one row for the cons_one aggregation
		if "`eq_mix'" == "cons_one" local eq_mix = "weekend"
	}
	else if "`agg_level'" == "agg_disagg" local eq_mix = "state year hour weekend"
	collapse (sum) a_* , by(`eq_mix')

	bysort `eq_mix': egen A_1=sum(a_1)
	bysort `eq_mix': egen A_2=sum(a_2)

	** Toss observations where there are no (one-vehicle, drunk) or no (one-vehicle, sober) crashes [won't converge otherwise]

	drop if A_1==0 | A_2==0

	sum a_*

	gen A= a_2_2+a_1_2+a_1_1+a_1+a_2

	save data_lp_drinking.dta, replace

	** Calculate the total number of crashes by type for summary stats and later calculations
	*}
	preserve

	collapse (sum) A A_1 A_2 a_1_1 a_1_2 a_2_2 a_1 a_2

	summarize A A_1 A_2 a_1_1 a_1_2 a_2_2 


	quietly summarize a_1_1, meanonly
	local Acc_1_1 = r(mean)
	quietly summarize a_1_2, meanonly
	local Acc_1_2 = r(mean)
	quietly summarize a_2_2, meanonly
	local Acc_2_2 = r(mean)
	quietly summarize a_1, meanonly
	local Acc_1 = r(mean)
	quietly summarize a_2, meanonly
	local Acc_2= r(mean)

	restore
	
	** Calculate summary stats of estimation sample
	sum a_1 a_2 a_1_1 a_1_2 a_2_2 A_1 A_2 A

	quietly log on
	display "{One vehicle, sober: " `Acc_1' "}; " "{One vehicle, drunk: " `Acc_2' "}; " "{Two vehicle, both sober: " `Acc_1_1' "}; " "{Two vehicle, mixed: " `Acc_1_2' "}; " "{Two vehicle, both drunk: " `Acc_2_2' "}; "
	quietly log off


	** Estimation


	/* Load the maximimum likelihood programs into memory (from separate do files) */
	* still need to construct disagg-disagg if we want to try it
	capture do "..\unified LP programs\agg_disagg_ml_prog.do"
	capture do "..\unified LP programs\agg_agg_ml_prog.do"




	/***** here I replicate Levitt and Porter for the 2 driver type case *****/
	set more 1

	*quietly log on
	gen cons_one=1

	/* theta and lambda */  
	if "`agg_level'" == "agg_disagg" {
		ml model lf agg_disagg_ml_prog (N: a_1 a_2 a_1_1 a_1_2 a_2_2 = `6') (sigma: ) (lambda_2_rel_1: ), tech(dfp 20 nr 20)
		ml maximize
		estimates store E
		
		lincom _b[sigma: _cons]+12
		local R = r(estimate)
		
		if `R' > 1  {
			local theta = r(estimate)
			local theta_se = r(se)
		}
		else {
			nlcom (rr_theta_2_recalc: 1/(_b[sigma: _cons]+12))
			matrix T=r(b)
			matrix TS=r(V)
			local theta = T[1,1]
			local theta_se = (TS[1,1])^0.5
		}

		if [lambda_2_rel_1]_b[_cons] > 1  {
			*nlcom (N: `Acc_2'/(`Acc_1'*[lambda_2_rel_1]_b[_cons])), post
			nlcom (N: (`Acc_2'/(`Acc_1'*[lambda_2_rel_1]_b[_cons]))/(1+`Acc_2'/(`Acc_1'*[lambda_2_rel_1]_b[_cons]))), post
				matrix N=e(b)
				matrix NS=e(V)
				local N=N[1,1]
				local N_se=(NS[1,1])^0.5
			estimates restore E
			local lambda = [lambda_2_rel_1]_b[_cons]
			local lambda_se = [lambda_2_rel_1]_se[_cons]
			
		}
		else {
			nlcom (rr_lambda_2_recalc: 1/[lambda_2_rel_1]_b[_cons])
			*nlcom (N: `Acc_2'*[lambda_2_rel_1]_b[_cons]/`Acc_1'), post
			nlcom (N: (`Acc_2'*[lambda_2_rel_1]_b[_cons]/`Acc_1')/(1+`Acc_2'*[lambda_2_rel_1]_b[_cons]/`Acc_1')), post
				matrix N=e(b)
				matrix NS=e(V)
				local N=N[1,1]
				local N_se=(NS[1,1])^0.5
			estimates restore E
			matrix L=e(b)
			matrix LS=e(V)
			local lambda = L[1,1]
			local lambda_se = (LS[1,1])^0.5
		}
	}
	else if "`agg_level'" == "agg_agg" {

		ml model lf agg_agg_ml_prog (theta_2_rel_1: a_1 a_2 a_1_1 a_1_2 a_2_2 = cons_one) (lambda_2_rel_1: ), vce(robust)
		ml check
		ml search
		ml maximize
		estimates store E

		* also calculate the reciprocal of the coefficients of interest, and report the value that is greater than one
		*nlcom (rr_theta_2_recalc: 1/[theta_2_rel_1]_b[_cons]) (rr_lambda_2_recalc: 1/[lambda_2_rel_1]_b[_cons])
		if [theta_2_rel_1]_b[_cons] > 1  {
			local theta = [theta_2_rel_1]_b[_cons]
			local theta_se = [theta_2_rel_1]_se[_cons]
		}
		else {
			nlcom (rr_theta_2_recalc: 1/[theta_2_rel_1]_b[_cons])
			matrix T=r(b)
			matrix TS=r(V)
			local theta = T[1,1]
			local theta_se = (TS[1,1])^0.5
		}

		if [lambda_2_rel_1]_b[_cons] > 1  {
			nlcom (N: `Acc_2'/(`Acc_1'*[lambda_2_rel_1]_b[_cons])), post
			*nlcom (N: (`Acc_2'/(`Acc_1'*[lambda_2_rel_1]_b[_cons]))/(1+`Acc_2'/(`Acc_1'*[lambda_2_rel_1]_b[_cons]))), post
				matrix N=e(b)
				matrix NS=e(V)
				local N=N[1,1]
				local N_se=(NS[1,1])^0.5
			estimates restore E
			local lambda = [lambda_2_rel_1]_b[_cons]
			local lambda_se = [lambda_2_rel_1]_se[_cons]
			
		}
		else {
			nlcom (rr_lambda_2_recalc: 1/[lambda_2_rel_1]_b[_cons])
			nlcom (N: `Acc_2'*[lambda_2_rel_1]_b[_cons]/`Acc_1'), post
			*nlcom (N: (`Acc_2'*[lambda_2_rel_1]_b[_cons]/`Acc_1')/(1+`Acc_2'*[lambda_2_rel_1]_b[_cons]/`Acc_1')), post
				matrix N=e(b)
				matrix NS=e(V)
				local N=N[1,1]
				local N_se=(NS[1,1])^0.5
			estimates restore E
			matrix L=e(b)
			matrix LS=e(V)
			local lambda = L[1,1]
			local lambda_se = (LS[1,1])^0.5
		}
	}

	local df = e(N)+ 2
	local ll = e(ll)

	*quietly log off
	
	quietly log on
	display "theta: " `theta' " (" `theta_se' ")
	display "lambda: " `lambda' " (" `lambda_se' ")
	display "N: " `N' " (" `N_se' ")"
	display "degrees of freedom    log likelihood" 
	display "`df'                    `ll'"
	quietly log close

	
	* return the estimated parameters for programmatic use
	return scalar theta = `theta'
	return scalar theta_se = `theta_se'
	return scalar lambda = `lambda'
	return scalar lambda_se = `lambda_se'
	return scalar N = `N'
	return scalar N_se = `N_se'
	return scalar df = `df'
	return scalar ll = `ll'
	
end
